#include <QCoreApplication>
#include <QCryptographicHash>
#include <QStringList>
#include <iostream>
using namespace std;

void printPasswordCreation(QString password, QStringList ids)
{
    QCryptographicHash hash(QCryptographicHash::Sha1);
    hash.addData(password.toUtf8());
    cout << "\tm_passwords.insert(";
    cout << " /*" << password.toUtf8().data() << "*/\t";
    cout << "\"" << hash.result().toHex().data() << "\"";
    cout << ", QSet<PERMISSION_ID>()";
    foreach(QString id, ids)
    {
        cout << " << ";
        cout << id.toUtf8().data();
    }
    cout << ");";
    cout << endl;
}

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);

    printPasswordCreation("trace123",           QStringList() << "TRACE_ENABLED");
    printPasswordCreation("bootloader123",      QStringList() << "READER_UPDATE_BOOTLOADER");
    cout << endl;
    printPasswordCreation("Sugumo60",           QStringList() << "SHOW_WILDCARD_ALL_FIRMWARE_FILES");
    printPasswordCreation("Awpinal6_HID",       QStringList() << "SHOW_WILDCARD_PUR_HID_KEYBOARD_FIRMWARE_FILES");
    printPasswordCreation("Otwaom46_IDTRONIC", 	QStringList() << "SHOW_WILDCARD_PUR_IDTRONIC_RUSSIA_FIRMWARE_FILES");
    cout << endl << "#if ENGINEERING_MODE_ALLOWED" << endl;
    printPasswordCreation("Pupoku58",           QStringList() << "READER_FREQUENCY_UNLIMITED");
    printPasswordCreation("Futete70",           QStringList() << "READER_ENGINEERING" << "TAG_ENGINEERING");
    printPasswordCreation("Kubavi85",           QStringList() << "READER_LAB_FUNCTIONS");
    printPasswordCreation("Galaha74",           QStringList() << "READER_HIDDEN_SETTINGS");
    printPasswordCreation("Dutefi25",           QStringList() << "READER_INTERFACE_SETTINGS");
    printPasswordCreation("Latapi71",           QStringList() << "READER_RFP_SETTINGS");
    printPasswordCreation("Noneki16",           QStringList() << "READER_ADVANCED_SETTINGS");
    printPasswordCreation("Kuwone25",           QStringList() << "READER_FREQUENCY_UNLIMITED" << "READER_ENGINEERING" << "READER_LAB_FUNCTIONS"<< "READER_HIDDEN_SETTINGS" << "READER_RFP_SETTINGS" << "READER_INTERFACE_SETTINGS" << "READER_ADVANCED_SETTINGS" << "TAG_ENGINEERING" << "READER_UPDATE_BOOTLOADER");
    cout << "#endif" << endl;


//    printPasswordCreation("",                   QStringList() << "");
//    printPasswordCreation("",                   QStringList() << "");
//    printPasswordCreation("",                   QStringList() << "");
//    printPasswordCreation("",                   QStringList() << "");


    return 0;
}
